#include "shaders.h"

extern CString ErrorLog, ModuleDirectory;

CShader::CShader()
{
	Shader = 0;
}

CShader::~CShader()
{
}

CShader::operator GLuint ()
{
	return Shader;
}

bool CShader::Load(char *ShaderFileName, GLenum Type)
{
	CString DirectoryShaderFileName = ModuleDirectory + "Shaders\\" + ShaderFileName;

	FILE *File = NULL;

	if(fopen_s(&File, DirectoryShaderFileName, "rb") != 0)
	{
		ErrorLog.Append("Error loading file " + DirectoryShaderFileName + "!\r\n");
		return false;
	}

	fseek(File, 0, SEEK_END);
	long Size = ftell(File);
	fseek(File, 0, SEEK_SET);
	char *Source = new char[Size + 1];
	fread(Source, 1, Size, File);
	fclose(File);
	Source[Size] = 0;

	Shader = glCreateShader(Type);

	glShaderSource(Shader, 1, (const char**)&Source, NULL);
	delete [] Source;
	glCompileShader(Shader);

	int CompileStatus;
	glGetShaderiv(Shader, GL_COMPILE_STATUS, &CompileStatus);

	if(CompileStatus == GL_FALSE)
	{
		ErrorLog.Append("Error compiling shader %s!\r\n", ShaderFileName);

		int InfoLogLength = 0;
		glGetShaderiv(Shader, GL_INFO_LOG_LENGTH, &InfoLogLength);
	
		if(InfoLogLength > 0)
		{
			char *InfoLog = new char[InfoLogLength];
			int CharsWritten  = 0;
			glGetShaderInfoLog(Shader, InfoLogLength, &CharsWritten, InfoLog);
			ErrorLog.Append(InfoLog);
			delete [] InfoLog;
		}

		return false;
	}

	return true;
}

CShaderProgram::CShaderProgram()
{
	UniformLocations = NULL;
	AttribLocations = NULL;
	Program = 0;
}

CShaderProgram::~CShaderProgram()
{
}

CShaderProgram::operator GLuint ()
{
	return Program;
}

bool CShaderProgram::Load(char *VertexShaderFileName, char *FragmentShaderFileName)
{
	bool Error = false;

	Error |= !VertexShader.Load(VertexShaderFileName, GL_VERTEX_SHADER);
	Error |= !FragmentShader.Load(FragmentShaderFileName, GL_FRAGMENT_SHADER);

	if(Error)
	{
		return false;
	}

	Program = glCreateProgram();
	glAttachShader(Program, VertexShader);
	glAttachShader(Program, FragmentShader);
	glLinkProgram(Program);

	int LinkStatus;
	glGetProgramiv(Program, GL_LINK_STATUS, &LinkStatus);

	if(LinkStatus == GL_FALSE)
	{
		ErrorLog.Append("Error linking program (%s, %s)!\r\n", VertexShaderFileName, FragmentShaderFileName);

		int InfoLogLength = 0;
		glGetProgramiv(Program, GL_INFO_LOG_LENGTH, &InfoLogLength);
	
		if(InfoLogLength > 0)
		{
			char *InfoLog = new char[InfoLogLength];
			int CharsWritten  = 0;
			glGetProgramInfoLog(Program, InfoLogLength, &CharsWritten, InfoLog);
			ErrorLog.Append(InfoLog);
			delete [] InfoLog;
		}

		return false;
	}

	return true;
}

void CShaderProgram::Destroy()
{
	delete [] UniformLocations;
	delete [] AttribLocations;

	glDetachShader(Program, VertexShader);
	glDetachShader(Program, FragmentShader);
	glDeleteShader(VertexShader);
	glDeleteShader(FragmentShader);
	glDeleteProgram(Program);
}
